/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;

public class DunDialInfo
implements Cloneable,
Comparable,
Serializable {
    private static final String TRACE_MASKT = "XCDIDDDT";
    private static final String TRACE_MASKF = "XCDIDDDF";
    private static final String TRACE_MASKD = "XCDIDDDD";
    private static final String DIALABLE_CHARS = "0123456789,";
    private static final String DIALABLE_LETTERS = "ABCDEFGHIJKLMNOPRSTUVWXYabcdefghijklmnoprstuvwxy";
    private static final String DIALABLE_LETTERS_CONVERTED = "222333444555666777888999222333444555666777888999";
    private static final long serialVersionUID = -1153130466196142902L;
    private String configuredNumber;
    private String baseNumber;
    private String country;
    private String region;
    private String description;
    private String dialPrefix;
    private boolean aMultiRegionNumber;

    public DunDialInfo(String phoneNumber, String baseNumber, String country, String region, String description, String dialPrefix, boolean multiRegion) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo() - " + phoneNumber + ", " + baseNumber + ", " + country + ", " + region + ", " + description + ", " + dialPrefix + ", " + multiRegion);
        if (country == null) {
            country = "  ";
        } else if (country.length() != 2) {
            String msg = "country argument is not 2 characters:  \"" + country + "\"";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        if (region == null) {
            region = "  ";
        } else if (region.length() != 2) {
            String msg = "region argument is not 2 characters:  \"" + region + "\"";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        if (phoneNumber == null) {
            phoneNumber = "";
        }
        if (baseNumber == null) {
            baseNumber = "";
        }
        if (description == null) {
            description = "";
        }
        if (dialPrefix == null) {
            dialPrefix = "";
        }
        this.configuredNumber = phoneNumber;
        this.baseNumber = baseNumber;
        this.country = country;
        this.region = region;
        this.description = description;
        this.dialPrefix = dialPrefix;
        this.aMultiRegionNumber = multiRegion;
        Trace.trace(TRACE_MASKT, "<- DunDialInfo()");
    }

    public DunDialInfo(String phoneNumber, String baseNumber, String country, String region, String description, String dialPrefix) {
        this(phoneNumber, baseNumber, country, region, description, dialPrefix, false);
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo.clone()");
        DunDialInfo copy = null;
        try {
            copy = (DunDialInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            copy = null;
            Trace.trace(TRACE_MASKF, " - DunDialInfo.clone() - catch CloneNotSupportedException");
        }
        copy.configuredNumber = new String(this.configuredNumber);
        copy.baseNumber = new String(this.baseNumber);
        copy.country = new String(this.country);
        copy.region = new String(this.region);
        copy.description = new String(this.description);
        copy.dialPrefix = new String(this.dialPrefix);
        copy.aMultiRegionNumber = this.aMultiRegionNumber;
        Trace.trace(TRACE_MASKT, "<- DunDialInfo.clone()");
        return copy;
    }

    public int hashCode() {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo.hashCode()");
        int hashcode = 0;
        hashcode ^= this.configuredNumber.hashCode();
        hashcode ^= this.baseNumber.hashCode();
        hashcode ^= this.country.hashCode();
        hashcode ^= this.region.hashCode();
        hashcode ^= this.description.hashCode();
        hashcode ^= this.dialPrefix.hashCode();
        if (this.aMultiRegionNumber) {
            hashcode ^= 0xFFFFFFFF;
        }
        Trace.trace(TRACE_MASKT, "<- DunDialInfo.hashCode() - " + hashcode);
        return hashcode;
    }

    public boolean equals(Object obj) {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo.equals()");
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DunDialInfo inDDD = (DunDialInfo)obj;
        boolean same = true;
        if (!this.configuredNumber.equals(inDDD.configuredNumber)) {
            same = false;
        }
        if (!this.baseNumber.equals(inDDD.baseNumber)) {
            same = false;
        }
        if (!this.country.equals(inDDD.country)) {
            same = false;
        }
        if (!this.region.equals(inDDD.region)) {
            same = false;
        }
        if (!this.description.equals(inDDD.description)) {
            same = false;
        }
        if (!this.dialPrefix.equals(inDDD.dialPrefix)) {
            same = false;
        }
        if (this.aMultiRegionNumber != inDDD.aMultiRegionNumber) {
            same = false;
        }
        Trace.trace(TRACE_MASKT, "<- DunDialInfo.equals() - " + same);
        return same;
    }

    public int compareTo(DunDialInfo anotherDunDialInfo) {
        return this.getDescription().compareTo(anotherDunDialInfo.getDescription());
    }

    public int compareTo(Object o) {
        return this.compareTo((DunDialInfo)o);
    }

    public String toString() {
        String display = this.configuredNumber + "," + this.baseNumber + "," + this.country + "," + this.region + "," + this.description + "," + this.dialPrefix + "," + this.aMultiRegionNumber;
        return display;
    }

    public String getBaseNumber() {
        return this.baseNumber;
    }

    public String getConfiguredNumber() {
        return this.configuredNumber;
    }

    public String getCountry() {
        return this.country;
    }

    public String getDialPrefix() {
        return this.dialPrefix;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDialString() {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo.getDialString() - " + this.configuredNumber);
        String rawDialString = this.dialPrefix + this.configuredNumber;
        String dialString = "";
        for (int i = 0; i < rawDialString.length(); ++i) {
            char newChar = ' ';
            char thisChar = rawDialString.charAt(i);
            int index = DIALABLE_CHARS.indexOf(thisChar);
            if (index != -1) {
                newChar = thisChar;
            }
            if ((index = DIALABLE_LETTERS.indexOf(thisChar)) != -1) {
                newChar = DIALABLE_LETTERS_CONVERTED.charAt(index);
            }
            if (newChar == 32) continue;
            dialString = dialString.concat(String.valueOf(newChar));
        }
        Trace.trace(TRACE_MASKT, "<- DunDialInfo.getDialString() - " + dialString);
        return dialString;
    }

    public boolean isMultiRegionNumber() {
        return this.aMultiRegionNumber;
    }

    public void setDialPrefix(String dialPrefix) {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo.setDialPrefix() - " + dialPrefix);
        if (dialPrefix == null) {
            dialPrefix = "";
        }
        this.dialPrefix = dialPrefix;
        Trace.trace(TRACE_MASKT, "<- DunDialInfo.setDialPrefix()");
    }

    public void setMultiRegionNumber() {
        Trace.trace(TRACE_MASKT, "-> DunDialInfo.setMultiRegionNumber()");
        this.aMultiRegionNumber = true;
        Trace.trace(TRACE_MASKT, "<- DunDialInfo.setMultiRegionNumber()");
    }
}

